// Topic 2: Access specifiers with public inheritance and multiple generations

#include <stdio.h>

class Base
{
	public:
		void A() { printf("A\n"); }

	protected:
		void B() { printf("B\n"); }

	private:
		void C() { printf("C\n"); }
};

class Child : public Base
{
	public:
		void Foo()
		{
			A(); // Call Base::A()
			B(); // Call Base::B()
		/*	C(); // CANNOT CALL THIS! */
		}
};

class Baby : public Child
{
	public:
		void Bar()
		{
			A();
			B();
		/*	C(); // CANNOT CALL THIS! */
		}
};

void main()
{
	Base base;
	base.A();	// Good!
/*	base.B();	// No good! */
/*	base.C();	// No good! */

	Child child;
	child.A();	// Good!
/*	child.B();	// No good! */
/*	child.C();	// No good! */
	child.Foo();

	Baby baby;
	baby.A();	// Good!
/*	baby.B();	// No good! */
/*	baby.C();	// No good! */
	baby.Bar();
	baby.Foo();

}